implementation module CMTypes

import iTaskUtil


// Types
:: User = { uid_   :: UserId
          , new_   :: Bool
          , login  :: Login
          , email  :: TextInput
          , role   :: Role
          , marks_ :: [(PaperId, Mark)]
          }
:: Role = Chair | PC
:: Mark = Conflict | Neutral | NoKnowledge | Preference

:: Paper = { pid_        :: PaperId
           , title       :: TextInput
           , author      :: TextInput
           , affiliation :: TextInput
           , email       :: TextInput
           , url         :: TextInput
           , abstract    :: TextArea
           }
:: PaperId :== Int

:: Review = { rid_           :: ReviewId 
			, paper_         :: PaperId
            , reviewer_      :: UserId
            , expertise      :: RadioGroup
            , verdict        :: RadioGroup
            , commentsAuthor :: TextArea
            , commentsPC     :: TextArea
            }
:: ReviewId  :== Int

:: Judgment = { jid_     :: JudgmentId
              , paper_   :: PaperId
              , decision :: Decision
              }
:: JudgmentId :== Int              
:: Decision = Accept | Reject

:: AssignedReviewer = { paper_ :: PaperId
                      , user_  :: UserId
                      , handle :: Wid Void
                      }

derive gForm  User, Login, Role, Mark, Paper, Review, Judgment, Decision, AssignedReviewer, Maybe, []
derive gUpd   User, Login, Role, Mark, Paper, Review, Judgment, Decision, AssignedReviewer, Maybe, []
derive gParse User, Login, Role, Mark, Paper, Review, Judgment, Decision, AssignedReviewer, Maybe
derive gPrint User, Login, Role, Mark, Paper, Review, Judgment, Decision, AssignedReviewer, Maybe
	         
	         
// Classes and instances
instance == Role where
  (==) Chair Chair = True
  (==) PC    PC    = True
  (==) _     _     = False